% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjpval.R
\name{adjpval}
\alias{adjpval}
\title{adjpval}
\usage{
adjpval(PRANAres)
}
\arguments{
\item{PRANAres}{An object called after running PRANA.}
}
\value{
A table that includes adjusted p-values for all variables included in the fitted model.
}
\description{
A function to retrieve a table with adjusted p-values after running PRANA.
 The table includes all variables that were included in the pseudo-value regression model.
}
\examples{
data(combinedCOPDdat_RGO) # A complete data containing expression and clinical data.

# A gene expression data part of the downloaded data.
rnaseqdat = combinedCOPDdat_RGO[ , 8:ncol(combinedCOPDdat_RGO)]
rnaseqdat = as.data.frame(apply(rnaseqdat, 2, as.numeric))

# A clinical data with additional covariates sorted by current smoking groups:
# The first column is ID, so do not include.
phenodat = combinedCOPDdat_RGO[order(combinedCOPDdat_RGO$currentsmoking), 2:7]

# Indices of non-current smoker (namely Group A)
index_grpA = which(combinedCOPDdat_RGO$currentsmoking == 0)
# Indices of current smoker (namely Group B)
index_grpB = which(combinedCOPDdat_RGO$currentsmoking == 1)

# Use PRANA() function to perform the pseudo-value regression analysis.
PRANAres <- PRANA(RNASeqdat = rnaseqdat, clindat = phenodat,
 groupA = index_grpA, groupB = index_grpB)

# Now, we want to keep the table with adjusted p-values only.
adjpval(PRANAres)
}
