% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSM_solver.R
\name{PSM_solver}
\alias{PSM_solver}
\title{Solve given problem in parametric simplex method}
\usage{
PSM_solver(A, b, b_bar, c, c_bar, B_init = NULL, max_it = 50,
  lambda_threshold = 0.01)
}
\arguments{
\item{A}{\code{A} is an \code{n} by \code{d} data matrix}

\item{b}{\code{b} is a length \code{n} response vector}

\item{b_bar}{\code{b_bar} is a length \code{n} vector time to parameter in constraints.}

\item{c}{\code{c} is a length \code{d} vector in target function.}

\item{c_bar}{\code{c_bar} is a length \code{d} vector time to parameter in target function}

\item{B_init}{\code{B_init} is the index of initial basic colume.}

\item{max_it}{This is the number of the maximum path length one would like to achieve. The default length is \code{50}.}

\item{lambda_threshold}{The parametric simplex method will stop when the calculated parameter is smaller than lambda. The default value is \code{0.01}.}
}
\value{
An object with S3 class \code{"primal"} is returned:
\item{data}{
  The \code{n} by \code{d} data matrix from the input
}
\item{response}{
  The length \code{n} response vector from the input
}
\item{beta}{
  A matrix of regression estimates whose columns correspond to regularization parameters for parametric simplex method.
}
\item{beta0}{
  A vector of regression estimates whose index correspond to regularization parameters for parametric simplex method.
}
\item{df}{
  The degree of freecom (number of nonzero coefficients) along the solution path.
}
\item{value}{
  The sequence of optimal value of the object function corresponded to the sequence of lambda.
}
\item{iterN}{
  The number of iteration in the program.
}
\item{lambda}{
  The sequence of regularization parameters \code{lambda} obtained in the program.
}
\item{type}{
  The type of the problem, such as \code{Dantzig} and \code{SparseSVM}.
}
}
\description{
Solve given problem in parametric simplex method
}
\examples{
## This example show how to use PSM_solver() to solve dantzig problem.
## Generate the design matrix and coefficient vector
n = 100 # sample number
d = 250 # sample dimension
c = 0.5 # correlation parameter
s = 20  # support size of coefficient
set.seed(1024)
X = scale(matrix(rnorm(n*d),n,d)+c*rnorm(n))/sqrt(n-1)*sqrt(n)
beta = c(rnorm(s), rep(0, d-s))
## Generate response using Gaussian noise, and solve the solution path
noise = rnorm(n)
Y = X\%*\%beta + noise
## Define parameters for dantzig problem
XtX = t(X)\%*\%X
A = cbind(cbind(rbind(XtX,-XtX),-rbind(XtX,-XtX)),diag(rep(1,2*d)))
b = rbind(t(X)\%*\%Y,-t(X)\%*\%Y)
c = c(rep(-1,2*d),rep(0,2*d))
c_bar = rep(0,4*d)
b_bar = rep(1,2*d)
B_init = seq(2*d,4*d-1)
## Dantzig selection solved with parametric simplex method
fit.dantzig = PSM_solver(A, b, b_bar, c, c_bar, B_init, max_it = 50, lambda_threshold = 0.01)
###lambdas used
print(fit.dantzig$lambda)
## number of nonzero coefficients for each lambda
print(fit.dantzig$df)
## Visualize the solution path
plot(fit.dantzig)
}
\seealso{
\code{\link{primal-package}}
}
