% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.prosper.R
\name{plot}
\alias{plot}
\alias{plot,prosper,missing-method}
\title{Simple plot for prosper simulation results}
\usage{
\S4method{plot}{prosper,missing}(x, y, plot_var = "SB_autumn", ...)
}
\arguments{
\item{x}{\code{prosper}, the result of a prosper simulation.}

\item{y}{not used.}

\item{plot_var}{variable, i.e. a column name of the result data.frame, to be plotted. \code{character}.}

\item{\dots}{other graphical parameters.}
}
\description{
This function draws three figures. i)Numerics: mean number of individual plants of a specified development stage for each simulation cycle,  summing up the genotypes to one number per cycle. ii)Raw counts: same as i) using the results of the repetitions instead of the mean. iii) Mean of the proportion of plants with only alleles for sensitivity, proportion of plants with only alleles for resistance, proportion of plants with mixed alleles for resistance and sensitivity, proportion of R alleles in the population.
}
\examples{
data(param.LOLRI)
mod_lolri    <- prosper.LOLRI(param.weed=param.LOLRI, area=20,  af = c(0.005, 0.01),
                                       duration=3, repetitions=2)
plot(mod_lolri)
}
\seealso{
\code{\link{summary}}
}
