% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pse_pssm.R
\name{pse_pssm}
\alias{pse_pssm}
\title{pseudo position-specific scoring matrix feature}
\usage{
pse_pssm(pssm_name, g = 1)
}
\arguments{
\item{pssm_name}{is the name of PSSM matrix file}

\item{g}{a parameter Which its size corresponds to the database used.}
}
\value{
feature vector of length 20+20*g
}
\description{
This feature vector is combination of \eqn{F_{PSSM}} feature vector and vector of
correlation factors correspond to 20 columns in PSSM Matrix. \eqn{F_{PSSM}} actually is mean of PSSM Matrix
columns of length 20.
}
\examples{
X<-pse_pssm(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
D.-J. Yu et al., "Learning protein multi-view features in complex space," vol. 44, no. 5, pp. 1365-1379,
2013.

Chou, K.C. and Shen, H.B. (2007) MemType-2L: a web server for predicting membrane proteins and their
types by incorporating evolution information through Pse-PSSM, Biochemical and Biophysical Research
Communications, 360, 339-345.
}
