% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avrami.R
\name{avrami}
\alias{avrami}
\title{Non-Linear Avrami Adsorption Kinetic Model}
\usage{
avrami(t, qt, qe)
}
\arguments{
\item{t}{the numerical value for contact time}

\item{qt}{the numerical value for the amount adsorbed at time t}

\item{qe}{the numerical value for the amount adsorbed at equilibrium. If qe is not defined, the value for qe will be equal to the maximum qt.}
}
\value{
the non-linear regression and the parameter estimation for the Avrami adsorption kinetic model analysis
}
\description{
The Avrami Adsorption Kinetic Model investigates the time-concentration profiles of sorbent-sorbate interactions in adsorption-based water treatment. This equation was developed with the experimentally supported assumptions that the new phase is nucleated by germ nuclei that already exist in the old phase, and whose number can be altered by previous treatment (Oladoja, 2016).
}
\examples{
\donttest{
t <- c(0,15,30,45,60,75,90,105,120)
qt <- c(0.000,3.718,3.888,4.102,4.274,4.402,4.444,4.488,4.616)
qe <- 4.68
avrami(t,qt,qe)}
}
\references{
Lopes, E. C. N., dos Anjos, F. S. C., Vieira, E. F. S., &; Cestari, A. R. (2003) <doi:10.1016/S0021-9797(03)00326-6> An alternative Avrami equation to evaluate kinetic parameters of the interaction of Hg(II) with thin chitosan membranes. Journal of Colloid and Interface Science, 263(2), 542-547.

Oladoja, N. A. (2016) <doi:10.1080/19443994.2015.1076355> A critical review of the applicability of Avrami fractional kinetic equation in adsorption-based water treatment studies. Desalination and Water Treatment, 57(34), 15813-15825.
}
\author{
Jeff Ryan S. Magalong

Joshua Z. DelaCruz

Jeann M. Bumatay

Chester C. Deocaris
}
