% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{createIterativeImputer}
\alias{createIterativeImputer}
\title{Create Iterative Imputer settings}
\usage{
createIterativeImputer(
  missingThreshold = 0.3,
  method = "pmm",
  methodSettings = list(pmm = list(k = 5, iterations = 5))
)
}
\arguments{
\item{missingThreshold}{The threshold for missing values to remove a feature}

\item{method}{The method to use for imputation, currently only "pmm" is supported}

\item{methodSettings}{A list of settings for the imputation method to use.
Currently only "pmm" is supported with the following settings:
\itemize{
\item k: The number of donors to use for matching
\item iterations: The number of iterations to use for imputation
}}
}
\value{
The settings for the iterative imputer of class \code{featureEngineeringSettings}
}
\description{
This function creates the settings for an iterative imputer
which first removes features with more than \code{missingThreshold} missing values
and then imputes the missing values iteratively using chained equations
}
\examples{
# create imputer to impute values with missingness less than 30\% using 
# predictive mean matching in 5 iterations with 5 donors
createIterativeImputer(missingThreshold = 0.3, method = "pmm",
                       methodSettings = list(pmm = list(k = 5, iterations = 5)))
}
