context("Screening")

f.test.pval = function(pval) {
  out = pval >= 0 && pval <= 1
  return(out)
}

data('hfdata')
N = 10
rets = hfdata[,1:10]

test_that("Alpha", {
  tmp = alphaScreening(rets, control = list(nCore = 1))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$alpha), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dalpha), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))

  tmp = alphaScreening(rets, control = list(nCore = 1, hac = TRUE))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$alpha), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dalpha), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))
})

test_that("Sharpe", {
  tmp = sharpeScreening(rets, control = list(nCore = 1))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$sharpe), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dsharpe), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))

  tmp = sharpeScreening(rets, control = list(nCore = 1, hac = TRUE))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$sharpe), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dsharpe), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))
})

test_that("Modified Sharpe", {
  tmp = msharpeScreening(rets, level = 0.9, control = list(nCore = 1))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$msharpe), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dmsharpe), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))

  tmp = msharpeScreening(rets, level = 0.95, control = list(nCore = 1, hac = TRUE))
  expect_equal(length(tmp$n), N)
  expect_equal(length(tmp$msharpe), N)
  expect_equal(length(tmp$npeer), N)
  expect_equal(length(tmp$lambda), N)
  expect_equal(dim(tmp$dmsharpe), c(N,N))
  expect_equal(dim(tmp$tstat), c(N,N))
  expect_equal(dim(tmp$pval), c(N,N))
})

