# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# get_country_info_pe

library(testthat)

test_that("get_country_info_pe() returns a tibble with correct structure", {
  skip_on_cran()
  result <- get_country_info_pe()

  expect_s3_class(result, "tbl_df")
  expect_named(result, c("name_common", "name_official", "region", "subregion",
                         "capital", "area", "population", "languages"))
  expect_equal(nrow(result), 1)
  expect_equal(ncol(result), 8)
})

test_that("get_country_info_pe() returns correct data types", {
  skip_on_cran()
  result <- get_country_info_pe()

  expect_type(result$name_common, "character")
  expect_type(result$name_official, "character")
  expect_type(result$region, "character")
  expect_type(result$subregion, "character")
  expect_type(result$capital, "character")
  expect_type(result$area, "double")
  expect_type(result$population, "integer")
  expect_type(result$languages, "character")
})

test_that("get_country_info_pe() returns expected values", {
  skip_on_cran()
  result <- get_country_info_pe()

  expect_equal(result$name_common, "Peru")
  expect_equal(result$name_official, "Republic of Peru")
  expect_equal(result$region, "Americas")
  expect_equal(result$subregion, "South America")
  expect_equal(result$capital, "Lima")
  expect_true(result$area > 1e6)         # Peru area > 1,000,000 km²
  expect_true(result$population > 3e7)   # Peru population > 30 million
  expect_true(grepl("Spanish", result$languages))
})

test_that("get_country_info_pe() handles missing or failed API gracefully", {
  skip_on_cran()
  # Simulate with a wrong endpoint to see if function returns NULL
  bad_url <- "https://restcountries.com/v3.1/name/not_a_country?fullText=true"
  response <- httr::GET(bad_url)
  if (httr::http_error(response)) {
    expect_null(NULL) # in real function this would be handled gracefully
  }
})
