# PeruAPIs - Access Peruvian Data via Public APIs and Curated Datasets
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# iscd_education_tbl_df

library(testthat)

# Test 1: Confirm the object is a tibble/data.frame
test_that("iscd_education_tbl_df is a tibble", {
  expect_s3_class(iscd_education_tbl_df, "tbl_df")
  expect_s3_class(iscd_education_tbl_df, "tbl")
  expect_s3_class(iscd_education_tbl_df, "data.frame")
})

# Test 2: Confirm it has exactly 8 columns
test_that("iscd_education_tbl_df has 8 columns", {
  expect_equal(length(iscd_education_tbl_df), 8)
})

# Test 3: Confirm it has exactly 8,357 rows
test_that("iscd_education_tbl_df has 8357 rows", {
  expect_equal(nrow(iscd_education_tbl_df), 8357)
})

# Test 4: Confirm column names are correct and in order
test_that("iscd_education_tbl_df has correct column names", {
  expect_named(iscd_education_tbl_df, c(
    "Education_COD", "Education", "Specific_COD", "Specific",
    "AcademicLevel", "AcademicLevel_COD",
    "EducationProgram", "EducationProgram_Lemma"
  ))
})

# Test 5: Confirm column types are correct
test_that("iscd_education_tbl_df columns have correct types", {
  expect_type(iscd_education_tbl_df$Education_COD, "character")
  expect_type(iscd_education_tbl_df$Education, "character")
  expect_type(iscd_education_tbl_df$Specific_COD, "character")
  expect_type(iscd_education_tbl_df$Specific, "character")
  expect_type(iscd_education_tbl_df$AcademicLevel, "character")
  expect_type(iscd_education_tbl_df$AcademicLevel_COD, "character")
  expect_type(iscd_education_tbl_df$EducationProgram, "character")
  expect_type(iscd_education_tbl_df$EducationProgram_Lemma, "character")
})
