__High-throughput phenotyping with electronic medical record data using a common semi-supervised approach (PheCAP)__

## Overview

Implement surrogate-assisted feature extraction (SAFE) and common machine learning approaches to train and validate phenotyping models. Background and details about the methods can be found at Zhang et al. (2019), 
Yu et al. (2016) and Liao et al. (2015).

## Installation

Install development version from GitHub:
 
```r
# install.packages("devtools")
devtools::install_github("celehs/PheCAP")
```

Install from [SOURCE CODE](https://github.com/celehs/PheCAP/blob/master/archive/PheCAP_1.0.tar.gz)

## Get Started

Follow the [main steps](https://celehs.github.io/PheCAP/articles/main.html), and try the R codes from the [simulated data](https://celehs.github.io/PheCAP/articles/example1.html) and [real EHR data](https://celehs.github.io/PheCAP/articles/example2.html) examples. 

## References

- Yichi Zhang`*`, Tianrun Cai`*`, Sheng Yu`*`, Kelly Cho, Chuan Hong, Jiehuan Sun, Jie Huang, Yuk-Lam Ho, Ashwin Ananthakrishnan, Zongqi Xia, Stanley Shaw, Vivian Gainer, Victor Castro, Nicholas Link, Jacqueline Honerlaw, Selena Huang, David Gagnon, Elizabeth Karlson, Robert Plenge, Peter Szolovits, Guergana Savova, Susanne Churchill, Christopher O'Donnell, Shawn Murphy, J Michael Gaziano, Isaac Kohane, Tianxi Cai`*`, and Katherine Liao`*`. [Methods for High-throughput Phenotyping with Electronic Medical Record Data Using a Common Semi-supervised Approach (PheCAP)](https://doi.org/10.1038/s41596-019-0227-6). _Nature Protocols_ (2019). `*`contributed equally. 

- Yu, S., Chakrabortty, A., Liao, K. P., Cai, T., Ananthakrishnan, A. N., Gainer, V. S., … Cai, T. [Surrogate-assisted feature extraction for high-throughput phenotyping](https://doi.org/10.1093/jamia/ocw135). _Journal of the American Medical Informatics Association_ (2017), e143-e149.  
- Liao, K. P., Cai, T., Savova, G. K., Murphy, S. N., Karlson, E. W., Ananthakrishnan, A. N., … Kohane, I. [Development of phenotype algorithms using electronic medical records and incorporating natural language processing](https://doi.org/10.1136/bmj.h1885). _BMJ_ (2015), 350(apr24 11), h1885–h1885. 
