% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qaqcs.R
\name{qaqcs}
\alias{qaqcs}
\title{Perform QA/QC on spectral data while preserving original column names}
\usage{
qaqcs(
  file_path,
  output_path,
  handle_missing = "NA",
  handle_outliers = "NA",
  group_by_col = "treatment"
)
}
\arguments{
\item{file_path}{Path to the input file}

\item{output_path}{Path to save the cleaned data}

\item{handle_missing}{Method to handle missing values ('impute', 'remove', or 'NA')}

\item{handle_outliers}{Method to handle outliers ('impute', 'remove', or 'NA')}

\item{group_by_col}{Column name for grouping}
}
\value{
A list with cleaned data and a summary table
}
\description{
Perform QA/QC on spectral data while preserving original column names
}
\examples{
library(openxlsx)
# Create mock raw data
raw_data <- data.frame(
  treatment = sample(0:1, 100, replace = TRUE),
  var1 = rnorm(100),
  var2 = rnorm(100),
  var3 = rnorm(100)
)

# Save mock data to a temporary file
raw_data_file <- tempfile(fileext = ".xlsx")
output_file <- tempfile(fileext = ".xlsx")

write.xlsx(raw_data, raw_data_file)

# Run QA/QC with missing values imputed and outliers removed
cleaned_result <- qaqcs(
  file_path = raw_data_file,
  output_path = output_file,
  handle_missing = "impute",
  handle_outliers = "remove",
  group_by_col = "treatment"
)
head(cleaned_result$cleaned_data)
}
