% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variancecomponentFunctions.R
\name{geneticFixedEffects}
\alias{geneticFixedEffects}
\title{Simulate genetic variant effects.}
\usage{
geneticFixedEffects(
  X_causal,
  P,
  N,
  phenoID = "Trait_",
  id_samples = rownames(X_causal),
  id_phenos = NULL,
  pTraitsAffected = 1,
  pIndependentGenetic = 0.4,
  pTraitIndependentGenetic = 0.2,
  keepSameIndependent = FALSE,
  distBeta = "norm",
  mBeta = 0,
  sdBeta = 1,
  verbose = FALSE
)
}
\arguments{
\item{X_causal}{[N x NrCausalSNPs] Matrix of [NrCausalSNPs] SNPs from [N] 
samples.}

\item{P}{Number [integer] of phenotypes to simulate.}

\item{N}{Number [integer] of samples to simulate; has to be provided as a 
dimnesionality check for X_causal and downstream analyses; nrow(X_causal) has 
to be equal to N.}

\item{phenoID}{Prefix [string] for naming traits.}

\item{id_samples}{Vector of [NrSamples] sample IDs [string]; if not provided
colnames(X_causal) used.}

\item{id_phenos}{Vector of [NrTraits] phenotype IDs [string]; if not provided
constructed by paste(phenoID, 1:P, sep="").}

\item{pTraitsAffected}{Proportion [double] of traits affected by the genetic
effect. For non-integer results of pTraitsAffected*P, the ceiling of the 
result is used. Allows to simulate for instance different levels of 
pleiotropy.}

\item{pIndependentGenetic}{Proportion [double] of genetic effects (SNPs) to
have an independent fixed effect.}

\item{pTraitIndependentGenetic}{Proportion [double] of traits influenced by 
independent fixed genetic effects.}

\item{keepSameIndependent}{[boolean] If set to TRUE, the independent genetic 
effects always influence the same subset of traits.}

\item{distBeta}{Vector of name(s) [string] of distribution to use to simulate 
effect sizes of SNPs; one of "unif" or "norm".}

\item{mBeta}{Vector of mean/midpoint(s) [double] of normal/uniform 
distribution for effect sizes of SNPs.}

\item{sdBeta}{Vector of standard deviation/distance from midpoint [double] 
of normal/uniform distribution for effect sizes of SNPs.}

\item{verbose}{[boolean] If TRUE, progress info is printed to standard out}
}
\value{
Named list of shared fixed genetic effects (shared: [N x P] matrix), 
independent fixed genetic effects (independent: [N x P] matrix), 
the causal SNPs labeled as shared or independent effect 
(cov: [NrCausalSNPs x N] matrix) and the simulated effect sizes of the causal 
SNPs (cov_effect: [P x NrCausalSNPs] dataframe).
}
\description{
geneticFixedEffects takes genetic variants which should be added as genetic 
variant effects to the phenotype. These variants can have the same effects 
across all traits (shared) or can be independent across traits (independent); 
in addition, only a certain proportion of traits can be affected by the 
genetic variants.
}
\examples{
genotypes <- simulateGenotypes(N=100, NrSNP=20, verbose=FALSE)
causalSNPs <- getCausalSNPs(N=100, genotypes=genotypes$genotypes)
geneticFixed <- geneticFixedEffects(N=100, X_causal=causalSNPs, 
P=10)
}
