% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{outlier}
\usage{
outlier(
  x,
  sample = NULL,
  year = NULL,
  loc = NULL,
  rep = NULL,
  phe = NULL,
  fold = 1.5,
  mode = "normal"
)
}
\arguments{
\item{x}{Input phenotype data file.}

\item{sample}{The column name of the sample name in phenotypic data. (Default: NULL)}

\item{year}{The column name of the year in phenotypic data. (Default: NULL)}

\item{loc}{The column name of the location in phenotypic data. (Default: NULL)}

\item{rep}{The column name of the replication in phenotypic data. (Default: NULL)}

\item{phe}{The column name of the phenotypic value in data. (Default: NULL)}

\item{fold}{Fold before inter-quartile range. (Default: 1.5)}

\item{mode}{Type of input phenotypic data. "normal" means normal data, "blup" means data containing year/location/repetition. (Default: "normal")}
}
\value{
phenotypic data with outliers removed.
}
\description{
Remove outliers from phenotypic data
}
\examples{
data("wheatds")
inlier <- outlier(wheatds, sample = "Line", loc = "Env", rep = "Rep", phe = "DS", mode = "blup")
}
\author{
Peng Zhao <pengzhao@nwafu.edu.cn>
}
