% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{DetectPlasmaMutation}
\alias{DetectPlasmaMutation}
\title{function DetectPlasmaMutation}
\usage{
DetectPlasmaMutation(patient.dir = "./", patient.name = NULL,
  pos_ranges.file = NULL, ber.ctrl.file = NULL, bai.ext = ".bai",
  n.trim = 8, cov.min = 0, force = FALSE, show.more = FALSE,
  qcutoff.snv = 0.95, qcutoff.indel = 0.99, cutoff.sb.ref = 0.1,
  cutoff.sb.hotspot = 3.1, cutoff.sb.nonhotspot = 2.5,
  hotspot.indel = "chr7:55227950:55249171", output.dir = patient.dir)
}
\arguments{
\item{patient.dir, }{char, foldername containing the rBAM folder of the patients. The typical folder hierarchy will consist of 'Plasma/rBAM'}

\item{patient.name, }{char, filename of the patient .bam file(s) (default NULL read all patients in folder \code{patient.dir})}

\item{pos_ranges.file, }{char, name of the Rdata file containing the three variables \code{pos_ind}, \code{pos_snp}, \code{pos_ranges} as build by the function \code{PrepareLibrary}. Default NULL, use the position_ranges.rda provides that we used for our analysis.}

\item{ber.ctrl.file, }{char, pathname of the file providing the background error rates obtained from the controls (default NULL use the provided background error rates obtained from our 29 controls). See \code{background_error_rate.txt} data and \code{BuildCtrlErrorRate} function.}

\item{bai.ext, }{char, filename extension of the bai files (default '.bai')}

\item{n.trim, }{integer, number of base positions trimmed at the ends of each amplicon (default 8)}

\item{cov.min, }{integer, minimal coverture required at each position (default 0)}

\item{force, }{boolean, (default FALSE) if TRUE force all computations to all files including already processed ones}

\item{show.more, }{boolean, (default FALSE show only detected positions) if TRUE additional annotations on result plots are given for non-significant mutations}

\item{qcutoff.snv, }{numeric, proportion of kept base positions ranged by increasing 95th percentile SNV PER in control samples (default 0.95)}

\item{qcutoff.indel, }{numeric, proportion of kept base positions ranged by increasing 95th percentile INDEL PER in control samples (default 0.99)}

\item{cutoff.sb.ref, }{numeric, exclude reference positions without cutoff < strand bias < 1-cutoff (default 0.1) (see Supplementary Materials in References)}

\item{cutoff.sb.hotspot, }{numeric, exclude hotspot positions with Symmetric Odds Ratio test > cutoff (default 3.1) (see Supplementary Materials in References)}

\item{cutoff.sb.nonhotspot, }{numeric, exclude non-hotspot positions with Symmetric Odds Ratio test > cutoff (default 2.5) (see Supplementary Materials in References)}

\item{hotspot.indel, }{char, a vector containing the known positions of hotspot deletion/insertion defined as chrX:start:end (default 'chr7:55227950:55249171')}

\item{output.dir, }{char, name of the folder to save results  (default \code{patient.dir}).}
}
\value{
the number of processed patients
}
\description{
This is the main function of the package that calls mutations by comparing at each genomic position the SNV or INDEL frequencies computed in one tested sample to
the SNV or INDEL Position-Error Rates computed from several control samples by a binomial test. An outlier detection is performed among all intra-sample p-values
to call a mutation.
For users wishing to develop their own analysis for other sequencing panel, it requires recalibrated BAM files control samples to be processed to compute the
Position-Error Rates stored in a file specified in \code{ber.ctrl.file}.
}
\examples{
     patient.dir=system.file("extdata","4test_only/case/",package="PlasmaMutationDetector")
     if (substr(patient.dir,nchar(patient.dir),nchar(patient.dir))!='/')
       patient.dir = paste0(patient.dir,'/') # TO RUN UNDER WINDOWS
     DetectPlasmaMutation(patient.dir,output.dir=paste0(tempdir(),'/'))


}
\references{
\emph{Analysis of base-position error rate of next-generation sequencing to detect tumor mutations in circulating DNA} N. Pécuchet, Y. Rozenholc, E. Zonta, D. Pietraz, A. Didelot, P. Combe, L. Gibault, J-B. Bachet, V. Taly, E. Fabre, H. Blons, P. Laurent-Puig in \emph{Clinical Chemistry}
}
\author{
N. Pécuchet, P. Laurent-Puig and Y. Rozenholc
}
