% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_cluster_genes_heatmap.R
\name{GEX_cluster_genes_heatmap}
\alias{GEX_cluster_genes_heatmap}
\title{Heatmap of cluster defining genes}
\usage{
GEX_cluster_genes_heatmap(
  GEX,
  GEX_cluster_genes.output,
  n.genes.per.cluster,
  metric,
  max.cell,
  group.colors,
  slot,
  platypus.version
)
}
\arguments{
\item{GEX}{Output Seurat object of either automate_GEX for platypus.version v2 or of VDJ_GEX_matrix for platypus.version v3 (usually VDJ_GEX_matrix.output[[2]])}

\item{GEX_cluster_genes.output}{The output from the GEX_cluster_genes function - this should be a list with each list element corresponding to the genes, p values, logFC, pct expression for the genes deferentially regulated for each cluster.}

\item{n.genes.per.cluster}{An integer value determining how many genes per cluster to display in the output heatmap. This number should be adjusted based on the number of clusters. Too many genes per cluster and clusters may cause a problem with the heatmap function in Seurat.}

\item{metric}{The metric that dictates which are the top n genes returned. Possible options are "p.value" (default), "avg_logFC", "top_logFC", "bottom_logFC". "top_logFC" returns the top expressed genes for each cluster, whereas "bottom_logFC" returns the least expressed genes per cluster-both by log fold change.}

\item{max.cell}{The max number of cells to display in the heatmap for each cluster, which corresponds to the number of columns. Default is set to 100 cells per cluster.}

\item{group.colors}{Optional character vector. Array of colors with the same length as GEX_cluster_genes.output to color bars above the heatmap. Defaults to rainbow palette}

\item{slot}{Seurat object slot from which to plot gene expression data.}

\item{platypus.version}{is set automatically}
}
\value{
Returns a heatmap from the function DoHeatmap from the package Seurat, which is a ggplot object that can be modified or plotted. The number of genes is determined by the n.genes parameter and the number of cells per cluster is determined by the max.cell argument. This function gives a visual description of the top genes differentially expressed in each cluster.
}
\description{
Produces a heatmap displaying the expression of the top genes that define each cluster in the Seurat object. The output heatmap is derived from DoHeatmap from Seurat and thereby can be edited using typical ggplot interactions. The number of genes per cluster and the nunber of cells to display can be specified by the user. Either the log fold change or the p value can be used to select the top n genes.
}
\examples{
\donttest{
try({
GEX_cluster_genes_output <- GEX_cluster_genes(GEX =
subset(Platypus::small_vgm[[2]],
seurat_clusters \%in\% c(0,1)), min.pct = .25
, filter = c("MT-", "RPL", "RPS"))

cluster_defining_gene_heatmap <- GEX_cluster_genes_heatmap(GEX =
Platypus::small_vgm[[2]]
,GEX_cluster_genes.output=GEX_cluster_genes_output
,n.genes.per.cluster=5,metric="p.value",max.cell=5)
})
}
}
