% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params.R
\name{get_params}
\alias{get_params}
\alias{mt3_get_param}
\alias{mt4_get_param}
\title{Get parameters for plots derivatives of multivariate CGF to assess
normality assumption.}
\usage{
mt3_get_param(p, bigt = seq(-1, 1, by = 0.05)/sqrt(p), l = NULL)

mt4_get_param(p, bigt = seq(-1, 1, by = 0.05)/sqrt(p), l = NULL)
}
\arguments{
\item{p}{Dimension.}

\item{bigt}{Array containing value of \eqn{t^*}.}

\item{l}{Linear transformation of vector of third/fourth distinct
derivatives, default is their average.}
}
\value{
\itemize{
\item{\code{p} Dimension.}
\item{\code{lT} Number of distinct third/fourth order derivatives.}
\item{\code{sTtTs} Two dimensional array, each element contains covariance
matrix of vector of derivatives, the function called
\code{\link[=mt3_covTtTs]{mt3_covTtTs()}}, or
\code{\link[=mt4_covTtTs]{mt4_covTtTs()}}}.
\item{\code{l.sTtTs} Covariance matrix of linear combination of distinct
derivatives, the function called \code{\link[=mt3_covLtLs]{mt3_covLtLs()}},
or \code{\link[=mt4_covLtLs]{mt4_covLtLs()}}.}
\item{\code{m.supLT} The Monte Carlo estimate of expected value supremum of
the Gaussian process, see \code{\link[=covLtLs]{covLtLs()}}.
}
}
\code{mt3_get_param} returns necessary parameters for the 2D plot
relying on third derivatives.
\code{mt4_get_param} returns necessary parameters for the 2D plot
relying on fourth derivatives.
}
\description{
Obtain necessary parameters to build a graphical test using
the third/fourth derivatives of cumulant generating function.
}
\examples{
\donttest{
p <- 2
mt3 <- mt3_get_param(p, bigt = seq(-1, 1, .5)/sqrt(p))
names(mt3)
mt4 <- mt4_get_param(p, bigt = seq(-1, 1, .5)/sqrt(p))
names(mt4)
}
}
\seealso{
\code{\link[=covZtZs]{covZtZs()}},
\code{\link[=covLtLs]{covLtLs()}}, \code{\link[=covTtTs]{covTtTs()}}
}
