% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPoDParameters.R
\name{PoDMLE}
\alias{PoDMLE}
\title{Setup for the maximum likelihood estimation (MLE)}
\usage{
PoDMLE(nondiseasedTiters,
              diseasedTiters,
              adjustTiters = FALSE,
              adjustFrom = log2(10),
              adjustTo = log2(5),
              initialSlope = 6,
              lowTiterPercent = 0.2)
}
\arguments{
\item{nondiseasedTiters}{numeric vector: non-diseased subjects titers}

\item{diseasedTiters}{numeric vector: diseased subjects titers}

\item{adjustTiters}{boolean: set to TRUE if titer values should be adjusted, for details see \code{PoD} function}

\item{adjustFrom}{numeric: value specifying the detection limit, all values below the detection limit will be adjusted to adjustTo value}

\item{adjustTo}{numeric: value to which titers below the detection limit will be adjusted}

\item{initialSlope}{numeric: initial guess of the slope parameter for the optimization function}

\item{lowTiterPercent}{numeric: value in the interval (0,1) - it represents a fraction of bottom titer values of the whole clinical trial used for calculation of inital guess of the pmax parameter.}
}
\value{
list("et50", "slope", "pmax"), named list of PoD paraters: if MLE converges.

Null: if MLE does not converge.
}
\description{
Function estimates the optimal PoD curve parameters (pmax, et50, slope) using diseased and non-diseased titers. Initial guess of the slope parameter needs to be provided as an input to the optimization, as well as the lowTiterPercent parameter, which is needed for initial guess of the pmax parameter calculation.
}
\details{
Initial guess of pmax = (number of diseased in the bottom titers + 0.5) / (number of non-diseased and diseased in the bottom titers + 0.5),
Initial et50 = intersection point of distributions of non-diseased and diseased groups. If L-BFGS-B optimization fails to converge, a new et50 initial guess is set to median value of all titers.

PoDMLE function estimates the PoD curve parameters by maximizing the likelihood value (see \code{MLE} function for details) based on the provided titers for diseased and non-diseased groups.

The \code{optim} function is used for optimization with method = "L-BFGS-B", 500 maximum iterations, (0.1,Inf) boundaries for et50, (1e-6,1) boundaries for pmax and (-slopeBoundary, slopeBoundary) boundaries for slope.

NOTE: The reason for slope boundary settings is because from certain value of slope parameter the shape of the PoD curve and the corresponding PoD values for given titers are almost identical. This parameter is expected to limit the resulting slope value and help MLE to converge to optimal parameters.
The value of "slopeBoundaries" is calculated as described by Dunning, 2015 (https://doi.org/10.1186/s12874-015-0096-9).
}
\examples{
## EXAMPLE 1:
# Data preparation
data(diseased)
data(nondiseased)

# PoD curve parameter estimation
PoDMLE(nondiseased$titers,
       diseased$titers)

## EXAMPLE 2:
## initialSlope and lowTiterPercent variables are adjusted.
PoDMLE(nondiseased$titers,
       diseased$titers,
       initialSlope = 5,
       lowTiterPercent = 0.3)

}
