% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_functional.R
\name{probit_spline3}
\alias{probit_spline3}
\title{cubic spline specification model with probit link}
\usage{
probit_spline3(stateVariable, theta, ...)
}
\arguments{
\item{stateVariable}{state variable}

\item{theta}{parameter}

\item{...}{...}
}
\value{
numeric level
}
\description{
All specification models can be used as parameter in \code{\link{estimate.functional}}.
Specification models are used to denote the quantile or expectile level
(depending on the identification function).
This specification model depends through a cubic spline on the state
variable and applies a probit link function.
}
\examples{
# plot example of cubic spline specification model with state-dependent quantile/expectile level
plot(function(x) probit_spline3(x,theta=c(0,2,1,-1)), xlim=c(-2,2))
}
\seealso{
Other specification models: \code{\link{constant}},
  \code{\link{logistic_linear}},
  \code{\link{probit_break}}, \code{\link{probit_linear}},
  \code{\link{probit_spline2}}
}
\concept{specification models}
