% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt.PolarCAP.R
\name{melt.PolarCAP}
\alias{melt.PolarCAP}
\title{Retrieve Tidy PolarCAP Data}
\usage{
melt.PolarCAP(
  countries = NA,
  years = NA,
  type = c("ideology", "affect"),
  include.se = FALSE
)
}
\arguments{
\item{countries}{a character vector of countries to be retrieved. See Details.}

\item{years}{a numeric vector of years to be retrieved.}

\item{type}{a character vector indicating which polarization estimates should be returned. Must be
\code{"ideology"}, \code{"affect"}, or both.}

\item{include.se}{a logical indicating whether standard errors should be returned. Defaults to
\code{FALSE}.}
}
\value{
a data frame with columns corresponding to country names, country ISO3 codes, years,
polarization types given in \code{type}, polarization estimates, and associated standard errors (if
\code{include.se = TRUE}).
}
\description{
Retrieves PolarCAP data for defined countries and years. Returns data in tidy format. For wide
format, or to return a polarization estimate as a scalar, use \code{\link{get.PolarCAP}()}.
}
\details{
Ideally, country names passed to \code{countries} would be ISO 3166-1 alpha-3 country codes
(case-insensitive). However, \code{melt.PolarCAP()} will accept country names in almost any language or
format and attempt to convert them to ISO3 codes by calling \code{\link{to.ISO3}()}.
\code{melt.PolarCAP()} will alert the user to any country names still unrecognized after this
conversion and return results only for those which are recognized.
}
\examples{
melt.PolarCAP("USA", c(2018, 2019), "ideology", include.se = TRUE)
melt.PolarCAP("USA", c(2018, 2019), c("ideology", "affect"), include.se = TRUE)

}
