% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{allhap}
\alias{allhap}
\title{Find all possible haplotypes}
\usage{
allhap(hapresults, haploblock)
}
\arguments{
\item{hapresults}{list as returned by inferhaplotypes, or one element
of such a list (i.e. the results for one haploblock)}

\item{haploblock}{if hapresults is one element of the return value of
inferHaplotypes, haploblock should be missing of NULL; else haploblock is
a single value indicating the haploblock: either its name of its index
in hapresults}
}
\value{
an array with all possible haplotypes. The haplotypes are in columns,
with the haplotype numbers as colnames; the markers are in rows.
}
\description{
Find all possible haplotypes for a haploblock from the
haplotyping result
}
\details{
This function works with the results of inferHaplotypes; the setting
of dropUnused does not affect this function
}
\examples{
data(PolyHaplotyper_small)
# show the composition of all possible haplotypes with the markers
# in the first haploblock:
allhap(hapresults=phresults, haploblock=1)
}
