% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/multilocusTypes.R
\name{multilocusTypes}
\alias{multilocusTypes}
\title{Genotype summaries}
\usage{
multilocusTypes(adata)
}
\arguments{
\item{adata}{data frame: the checked and preprocessed dataset
returned by \code{\link{inputData}}.}
}
\value{
A list structure, with the following components:

\describe{

\item{\code{uniqueProgenyTypes}}{A data frame containing, for each
locus, the distinct genotypes that are present in the progeny in
the dataset, and the numbers of progeny containing each genotype
at that locus.}

\item{\code{numUniqueProgenyTypes}}{The number of unique genotypes
at each locus in the progeny in the dataset.}

\item{\code{uniqueAdultTypes}}{A data frame containing, for each
locus, the distinct genotypes that are present in the adults in
the dataset, and the numbers of adults containing each genotype at
that locus.}

\item{\code{numUniqueAdultTypes}}{The number of unique genotypes
at each locus in the adult set.}

\item{\code{uniqueProgenyMLTypes}}{A data frame containing the
distinct genotypes \emph{across all loci} that are present in the
progeny in the dataset, and the numbers of progeny containing each
multilocus genotype.}

\item{\code{numUniqueProgenyMLTypes}}{The total number of progeny
multilocus genotypes.}

\item{\code{uniqueAdultMLTypes}}{A data frame containing, the
distinct genotypes \emph{across all loci} that are present in the
adults in the dataset, and the numbers of adults containing each
multilocus genotype.}

\item{\code{numUniqueAdultMLTypes}}{The total number of adult
multilocus genotypes.}

}
}
\description{
Return summaries of individual- and multi- locus genotypes for
adults and progeny.
}
\details{
Function \code{multilocusTypes} summarises the different genotypes
present at each locus in the dataset (separately for progeny and
adults), and across the loci (again, separately for progeny and
adults). \code{multilocusTypes} returns a list structure with
several elements.
}
\examples{
## Using the example dataset 'FR_Genotype':
data(FR_Genotype)

## Since we did not load this dataset using inputData(), we must
## first process it with preprocessData() before doing anything
## else:
gData <- preprocessData(FR_Genotype,
                        numLoci=7,
                        ploidy=4,
                        dataType="genotype",
                        dioecious=TRUE,
                        mothersOnly=TRUE)

head(gData)  ## Checked and Cleaned version of FR_Genotype

mTypes <- multilocusTypes(gData)

## mTypes is a list structure - individual components can be
## printed to the screen, or saved to file via, e.g. read.csv().

mTypes$numUniqueProgenyTypes

## Components of mTypes
names(mTypes)
}
\author{
Alexander Zwart (alec.zwart at csiro.au)
}

