% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi.R
\name{chiPool}
\alias{chiPool}
\title{Chi-squared p-value pooling}
\usage{
chiPool(p, kappa)
}
\arguments{
\item{p}{numeric vector of p-values between 0 and 1}

\item{kappa}{numeric value between 0 and infinity}
}
\value{
A pooled p-value between 0 and 1.
}
\description{
This implements the chi-squared pooled p-value
which can be used to control the centrality quotient when pooling
p-values.
}
\details{
The chi-squared pooled p-value is a quantile
transformation pooled p-value based on the chi-squared
distribution with degrees of freedom kappa. By setting kappa
between 0 and infinity, smooth interpolation is achieved between
Tippett's minimum pooled p-value and Stouffer's normal quantile
pooled p-value respectively. Choosing a kappa value of 2, Fisher's
pooling function is obtained. Tippett's pooled p-value is
maximally non-central and Stouffer's is maximally central, while
Fisher's presents a balance between marginal and central
rejection.
}
\examples{
p <- c(0.1, 0.5, 0.9)
chiPool(p, exp(-4))
chiPool(p, 2)
chiPool(p, exp(4))
}
\author{
Chris Salahub
}
