% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{estimatePc}
\alias{estimatePc}
\title{Compute the central rejection level}
\usage{
estimatePc(
  poolFun,
  alpha = 0.05,
  M = 2,
  interval = c(0, 1),
  poolArgs = list(),
  ...
)
}
\arguments{
\item{poolFun}{function accepting a vector of p-values}

\item{alpha}{numeric between 0 and 1}

\item{M}{integer, how many p-values are there?}

\item{interval}{two numerics giving the bounds of root-searching}

\item{poolArgs}{(optional) additional named arguments for poolFun}

\item{...}{additional arguments to uniroot}
}
\value{
The uniroot output.
}
\description{
Estimates the central rejection level for an
arbitrary pooled p-value function.
}
\details{
The central rejection level is the maximum p-value
shared among all tests which still results in rejection of the
null using a pooled p-value.

This function is essentially a wrapper for uniroot, and accepts
a pooling function which takes a numeric vector as its first
argument and potentially other arguments given in poolArgs and
returns a single value. Using this pooling function, a specified
dimension M and a rejection level alpha, uniroot searches for the
root to poolFun - alpha along the line where all p-values are
equal.
}
\examples{
tippool <- function(p) 1 - (1 - min(p))^(length(p))
estimatePc(tippool, 0.05, M = 10, interval = c(0, 1))
}
\author{
Chris Salahub
}
