% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hr.R
\name{hrPr}
\alias{hrPr}
\title{Empirical UMP beta marginal rejection level}
\usage{
hrPr(w, alpha = 0.05, M = 2, nsim = 1e+05)
}
\arguments{
\item{w}{numeric between 0 and 1}

\item{alpha}{numeric between 0 and 1}

\item{M}{integer sample size greater than 0}

\item{nsim}{integer, the number of simulated null cases generated}
}
\value{
A numeric between 0 and 1.
}
\description{
Uses simulation to estimate the marginal rejection
level for the UMP pooled p-value of a restricted beta family
}
\details{
The marginal rejection level is the maximum p-value
in a single tests which still results in rejection of the null
when all other tests have a p-value of 1.

To test the null hypotheses that all p-values are uniform
against a restricted beta family 0 < a <= 1 <= b, the most
powerful pooled p-value linearly combines upper and lower tail
probabilities of the chi-squared distribution with two degrees
of freedom with weights w and (1 - w) where w = (1 - a)/(b - a).

This function estimates the marginal rejection level empirically
by simulating a specified number of null cases to give an empirical
pooled p-value for the rejection level alpha.
}
\examples{
hrPr(w = 0.5, alpha = 0.05, M = 10)
hrPr(w = 0.5, alpha = 0.05, M = 10) # decreases in sample size
}
\author{
Chris Salahub
}
