% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependentChi.R
\name{satterChiPool}
\alias{satterChiPool}
\title{Pool p-values using the Satterthwaite approximation}
\usage{
satterChiPool(ps, covmat, kappa)
}
\arguments{
\item{ps}{numeric vector of M p-values}

\item{covmat}{M by M covariance matrix of chi-squared random
variables arising from quantile transformations of ps}

\item{kappa}{numeric degrees of freedom}
}
\value{
A pooled p-value between 0 and 1.
}
\description{
Compute the pooled p-value of dependent p-values
based on the dependence present when they are all converted
to chi-squared random variables by the same chi-squared
quantile function.
}
\details{
Care must be taken in the arguments for this function, as
the covmat argument accepts the covariance of the transformed
variables rather than the covariance of the p-values, and so
passes the argument covmat directly to the function that computes
the Satterthwaite approximation. For the case of genetic markers,
the `convertGeneticSigma` function provides the appropriate matrix
given a genetic correlation matrix.
}
\author{
Chris Salahub
}
