% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addind.R
\name{addind}
\alias{addind}
\title{Add a variable indicating whether the person is in education, or has left education}
\usage{
addind(
  people,
  pplid,
  pplsx,
  pplage,
  pplyear,
  minedage = NULL,
  maxedage = NULL,
  leavers,
  lvrsx,
  lvrage,
  lvryear,
  lvrcount,
  pyramid,
  pyrsx,
  pyrage,
  pyrcount,
  stvarname = "Status",
  verbose = FALSE,
  userseed = NULL
)
}
\arguments{
\item{people}{A data frame containing individual people.}

\item{pplid}{The variable containing the unique identifier for each person, in the people data frame}

\item{pplsx}{The variable containing the codes for sex, in the people data frame.}

\item{pplage}{The variable containing the ages, in the people data frame.}

\item{pplyear}{The year associated with the people data frame.}

\item{minedage}{The minimum age that a person, normally a child, can enter education.}

\item{maxedage}{The maximum age that a person, normally an adolescent, can leave education.}

\item{leavers}{A data frame containing the counts, by sex, age, and year, of the people who have left education.}

\item{lvrsx}{The variable containing the codes for sex, in the leavers data.}

\item{lvrage}{The variable containing the codes for sex, in the leavers data.}

\item{lvryear}{The variable containing the year for the lvrcount.}

\item{lvrcount}{The variable containing the counts for each sex/age combination in the leavers data.}

\item{pyramid}{A data frame containing the sex/age pyramid to be used.}

\item{pyrsx}{The variable containing the codes for sex, in the pyramid data.}

\item{pyrage}{The variable containing the ages, in the pyramid data.}

\item{pyrcount}{The variable containing the counts for each sex/age combination, in the pyramid data}

\item{stvarname}{The name of the variable to contain the education status. The output is "Y" for those still in education and "N" for those not in education.}

\item{verbose}{If TRUE, the proportion of students who have left school by age and sex will be printed to the console. Default is FALSE}

\item{userseed}{If specified, this will set the seed to the number provided. If not, the normal set.seed() function will be used.}
}
\value{
A data frame of an observations, with an added column that contains the education status of each person.
}
\description{
Creates a data frame with a variable indicating whether the person is a student, or is not in education. This is an factor with two levels. Pre-cleaning so that only people inside the student age range is not required.
Three data frames are required. The first is the data frame that contains the people ("people") to whom the indicator will be applied. The other two data frames are counts: school leaver counts ("leavers"), and the sex/age pyramid counts ("pyramid") that apply to the school leaver counts. As cumulative proportions of school leavers are calculated, the leavers data frames must contain multiple years of data. For example, if the minimum school leaving age is 17 and the maximum age is 18, then there must be two years of data in the leavers data frame. The pyramid data frame contains the sex/age counts for the relevant year. For example, if the people data frame is based on 2021 data frame, then the pyramid data frame should be the counts for 2021, and the value for pplyear would be 2021.
The variables specifying sex can be numeric, character, or factor. The sole requirement is that the same code is used in all three data frames. For example, if "F" and "M" are used in the adolescents data frame to denote sex, then "F" and "M" are the codes required in both the leavers and pyramid data frames. Any number of values can be used, so long as they are unique.
}
\details{
The proportion of people, by age and sex, who have left school is printed to the console.
}
\examples{
WithInd <- addind(Township, pplid = "ID", pplsx = "Sex", pplage = "Age", pplyear = 2018,
                  minedage = 5, maxedage = 18, LeftSchool, lvrsx = "Sex", lvrage = "Age",
                  lvryear = "YearLeft", lvrcount = "Total", RegionalStructure,
                  pyrsx = "Sex", pyrage = "Age", pyrcount = "Value", stvarname = "Status",
                  verbose = TRUE, userseed = 4)
}
