% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment.functions.R
\name{set.portfolio.moments}
\alias{set.portfolio.moments}
\alias{set.portfolio.moments_v2}
\title{Portfolio Moments}
\usage{
set.portfolio.moments(
  R,
  portfolio,
  momentargs = NULL,
  method = c("sample", "boudt", "black_litterman", "meucci"),
  ...
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of asset returns}

\item{portfolio}{an object of type "portfolio" specifying the constraints and objectives for the optimization, see \code{\link{portfolio.spec}}}

\item{momentargs}{list containing arguments to be passed down to lower level functions, default NULL}

\item{method}{the method used to estimate portfolio moments. Valid choices include "sample", "boudt", and "black_litterman".}

\item{\dots}{any other passthru parameters}
}
\description{
Set portfolio moments for use by lower level optimization functions. Currently
three methods for setting the moments are available
}
\details{
\describe{
  \item{sample: }{sample estimates are used for the moments}
  \item{boudt: }{estimate the second, third, and fourth moments using a 
  statistical factor model based on the work of Kris Boudt.}
  See \code{\link{statistical.factor.model}}
  \item{black_litterman: }{estimate the first and second moments using the 
  Black Litterman Formula. See \code{\link{black.litterman}}}.
}
}
