% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{roll_fit_predict}
\alias{roll_fit_predict}
\title{Rolling fit/predict for tabular features (pooled / per-symbol / per-group)}
\usage{
roll_fit_predict(
  features_list,
  label,
  fit_fn,
  predict_fn,
  is_periods = 156L,
  oos_periods = 4L,
  step = 4L,
  group = c("pooled", "per_symbol", "per_group"),
  group_map = NULL,
  na_action = c("omit", "zero")
)
}
\arguments{
\item{features_list}{list of wide panels (each: \code{Date} + symbols).}

\item{label}{wide panel of future returns (same symbol set as features).}

\item{fit_fn}{function \verb{(X, y) -> model} trained on in-sample stacked rows.}

\item{predict_fn}{function \verb{(model, Xnew) -> numeric} scores.}

\item{is_periods, oos_periods, step}{ints; in-sample length, out-of-sample length,
and step size for the rolling window.}

\item{group}{one of \code{"pooled"}, \code{"per_symbol"}, \code{"per_group"}.}

\item{group_map}{optional \code{data.frame(Symbol, Group)} if \code{group = "per_group"}.}

\item{na_action}{\code{"omit"} or \code{"zero"} for feature NA handling.}
}
\value{
wide panel of scores: \code{Date + symbols}.
}
\description{
Rolling fit/predict for tabular features (pooled / per-symbol / per-group)
}
\examples{
\donttest{
data(sample_prices_weekly); data(sample_prices_daily)
mom <- panel_lag(calc_momentum(sample_prices_weekly, 12), 1)
vol <- panel_lag(align_to_timeframe(
  calc_rolling_volatility(sample_prices_daily, 20),
  sample_prices_weekly$Date, "forward_fill"), 1)
Y <- make_labels(sample_prices_weekly, horizon = 4, type = "log")
fit_lm  <- function(X,y){ Xc <- cbind(1,X); list(coef=stats::lm.fit(Xc,y)$coefficients) }
pred_lm <- function(m,X){ as.numeric(cbind(1,X) \%*\% m$coef) }
S <- roll_fit_predict(list(mom=mom, vol=vol), Y, fit_lm, pred_lm, 52, 4, 4)
head(S)
}
}
