% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StandUnitCube.R
\name{standardize}
\alias{standardize}
\title{Standardizes the matrix given as input}
\usage{
standardize(xx)
}
\arguments{
\item{xx}{Matrix or a data frame of numeric entries}
}
\value{
Matrix with columns that have mean zero and variance one
}
\description{
This function takes as input a matrix of numeric values and then transforms it
             so that each column has a mean of zero and a variance of one
}
\examples{
\dontrun{
# I don't want you to run this
}
n<-450; x <- data.frame(cbind(rnorm(n, 162, 4), rnorm(n, 108, 2),
rnorm(n, 117, 3), rnorm(n, 36, 2), rnorm(n, 45, 2)))
p <- ncol(x)
x.stan <- standardize(x)
round(head(x),2)
round(head(x.stan),2)
round(rbind(apply(x, 2, mean), apply(x.stan, 2, mean)),2)
round(rbind(apply(x, 2, sd),apply(x.stan, 2, sd)),2)

oldpar <- par(mfrow=c(1,2))
boxplot(x[,1:min(5,p)], main='Original Data', col=rainbow(9))
boxplot(x.stan[,1:min(5,p)], main='PreProcessed Data', col=rainbow(7))
par(oldpar)
}
