% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{pre_post_fit}
\alias{pre_post_fit}
\title{Pre-Post Fitness Data}
\format{
A data frame with 20 rows and 12 variables:
\describe{
\item{ID}{A unique identifier for each subject.}
\item{Time}{A numeric variable indicating time points, \code{0} for pre-intervention and \code{1} for post-intervention.}
\item{Sex}{A numeric variable indicating sex: \code{0} for male and \code{1} for female.}
\item{Age}{A numeric variable representing the age of each subject.}
\item{COPM_p}{A numeric vector representing performance scores on the Canadian Occupational Performance Measure (COPM).}
\item{COPM_s}{A numeric vector representing satisfaction scores on the COPM.}
\item{A1_work}{A numeric vector representing work capacity scores at time A1.}
\item{A2_work}{A numeric vector representing work capacity scores at time A2.}
\item{Grip_dom}{A numeric vector representing grip strength of the dominant hand.}
\item{Grip_ndom}{A numeric vector representing grip strength of the non-dominant hand.}
\item{Flex_right}{A numeric vector representing right arm flexibility.}
\item{Flex_left}{A numeric vector representing left arm flexibility.}
}
}
\usage{
pre_post_fit
}
\description{
A dataset showing physical and cognitive performance measures before and after a fitness intervention.
}
\examples{
data(pre_post_fit)
head(pre_post_fit)
}
\keyword{datasets}
