% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\name{write.sample}
\alias{write.sample}
\alias{write.sample,PTSample,character-method}
\title{Write a PTSample object to an audio file}
\usage{
\S4method{write.sample}{PTSample,character}(sample, filename, what = c("wav", "8svx", "raw"))
}
\arguments{
\item{sample}{A \code{PTSample} object that needs to be exported to an audio
file.}

\item{filename}{A \code{character} string representing the filename to which
the audio needs to be saved.}

\item{what}{A \code{character} string indicating what type of file is to be
exported. Can be one of the following: \code{"wav"} (default),
\code{"8svx"} or \code{"raw"}. The \code{AmigaFFH} package needs to be
installed in order to write 8svx files.}
}
\value{
Saves the audio to a file, but returns nothing.
}
\description{
Write a \code{PTSample} as a "wav", "8svx" or "raw" audio file.
}
\details{
This method provides a wrapper for the \code{\link[tuneR:writeWave]{tuneR::writeWave}} method
from \code{\link[tuneR:tuneR]{tuneR::tuneR}}. It also provides the means to export audio
to file formats native to the Commodore Amiga. \code{PTSample}s can be
exported as simple (uncompressed) \href{https://en.wikipedia.org/wiki/8SVX}{8svx}
files also known as "iff" files). In addition they can be exported as raw data,
where each byte simply represents a signed integer value of the waveform.
}
\examples{
data("mod.intro")

## Export the second sample of mod.intro as a wav file:
write.sample(PTSample(mod.intro, 2), tempfile(fileext = ".wav"), "wav")

## Export the second sample of mod.intro as an 8svx file:
write.sample(PTSample(mod.intro, 2), tempfile(fileext = ".iff"), "8svx")

## Export the second sample of mod.intro as a raw file:
write.sample(PTSample(mod.intro, 2), tempfile(fileext = ".raw"), "raw")
}
\seealso{
Other sample.operations: 
\code{\link{PTSample-class}},
\code{\link{PTSample-method}},
\code{\link{fineTune}()},
\code{\link{loopLength}()},
\code{\link{loopSample}()},
\code{\link{loopStart}()},
\code{\link{loopState}()},
\code{\link{name}},
\code{\link{playSample}()},
\code{\link{read.sample}()},
\code{\link{sampleLength}()},
\code{\link{volume}()},
\code{\link{waveform}()}

Other io.operations: 
\code{\link{read.module}()},
\code{\link{read.sample}()},
\code{\link{write.module}()}
}
\author{
Pepijn de Vries
}
\concept{io.operations}
\concept{sample.operations}
