% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_extraction.R
\name{seq2feature_mds_stochastic}
\alias{seq2feature_mds_stochastic}
\title{Feature extraction by stochastic mds}
\usage{
seq2feature_mds_stochastic(seqs = NULL, K = 2,
  dist_type = "oss_action", max_epoch = 100, step_size = 0.01,
  pca = TRUE, tot = 1e-06, return_dist = FALSE, L_set = 1:3)
}
\arguments{
\item{seqs}{a \code{"\link{proc}"} object or a square matrix. If a squared matrix is 
provided, it is treated as the dissimilary matrix of a group of response processes.}

\item{K}{the number of features to be extracted.}

\item{dist_type}{a character string specifies the dissimilarity measure for two
response processes. See 'Details'.}

\item{max_epoch}{the maximum number of epochs for stochastic gradient
descent.}

\item{step_size}{the step size of stochastic gradient descent.}

\item{pca}{a logical scalar. If \code{TRUE}, the principal components of the
extracted features are returned.}

\item{tot}{the accuracy tolerance for determining convergence.}

\item{return_dist}{logical. If \code{TRUE}, the dissimilarity matrix will be
returned. Default is \code{FALSE}.}

\item{L_set}{length of ngrams considered.}
}
\value{
\code{seq2feature_mds_stochastic} returns a list containing 
  \item{theta}{a numeric matrix giving the \code{K} extracted features or principal
  features. Each column is a feature.} 
  \item{loss}{the value of the multidimensional scaling objective function.}
  \item{dist_mat}{the dissimilary matrix. This element exists only if \code{return_dist=TRUE}.}
}
\description{
Feature extraction by stochastic mds
}
