% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_differences.R
\name{identify_diff}
\alias{identify_diff}
\title{Identify posterior mean differences}
\usage{
identify_diff(posterior, CI_level = 0.05, nb_samples = 1000)
}
\arguments{
\item{posterior}{A tibble, typically coming from a \code{posterior_mean()}
function, containing the parameters of the multivariate posterior
t-distributions for the mean of the considered groups and draws for each
peptide.}

\item{CI_level}{A number, defining the order of quantile chosen to assess
differences between groups.}

\item{nb_samples}{A number (optional), indicating the
number of samples to draw from the posteriors for computing mean and
credible intervals . Only used if \code{posterior} is multivariate,
typically coming from a \code{multi_posterior_mean()} function.}
}
\value{
A tibble, indicating which peptides and groups seem to be different
}
\description{
Compute a criterion based on Credible Intervals (CI) to determine whether
the posterior t-distributions of groups should be considered different enough
to deserve further examination. Two groups are considered probably 'distinct'
if the Credible Interval of level \code{CI_level} of their respective
posterior t-distributions do not overlap.
}
\examples{
TRUE
}
