% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{set_trial}
\alias{set_trial}
\title{Set the Current Active Trial}
\usage{
set_trial(trial_name)
}
\arguments{
\item{trial_name}{A string specifying the name of the trial to set as active.}
}
\value{
No return value. The internal state is updated with the selected trial.
}
\description{
Updates the internal state to set the selected trial as the current active trial using the 
associated trialDbId. This enables operations to be carried out within the context of the selected trial.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  set_crop("wheat")  # Set crop
  set_program("Wheat International Nurseries")  # Set breeding program
  set_trial("IDYT39")  # Set trial
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{set_program}}, \code{\link{list_trials}} for operations involving crops, programs, and trials.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
