% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AverageStrike.R
\name{AverageStrikeMC}
\alias{AverageStrikeMC}
\title{Average Strike option valuation via Monte Carlo (MC) simulation}
\usage{
AverageStrikeMC(o = OptPx(o = Opt(Style = "AverageStrike")), NPaths = 5)
}
\arguments{
\item{o}{The AverageStrike \code{OptPx} option to price.}

\item{NPaths}{the number of simulations to use in calculating the price,}
}
\value{
The original option object \code{o} with the price in the field \code{PxMC} based on the MC simulations.
}
\description{
Calculates the price of an Average Strike option using Monte Carlo simulations
by determining the determine expected payout. Assumes that the input option follows a General
Brownian Motion \eqn{ds = mu * S * dt + sqrt(vol) * S * dz} where \eqn{dz ~ N(0,1)}
Note that the value of \eqn{mu} (the expected price increase) is assumped to be
\code{o$r}, the risk free rate of return. Additionally, the averaging period is
assumed to be the life of the option.
}
\examples{
(o = AverageStrikeMC())$PxMC   #Price =~ $3.6

  o = OptPx(o = Opt(Style='AverageStrike'), NSteps = 5)
  (o = AverageStrikeMC(o))$PxMC # Price =~ $6

  (o = AverageStrikeMC(NPaths = 20))$PxMC  #Price =~ $3.4

  o = OptPx(o = Opt(Style='AverageStrike'), NSteps = 5)
  (o = AverageStrikeMC(o, NPaths = 20))$PxMC  #Price =~ $5.6
}
\author{
Jake Kornblau, Department of Statistics and Department of Computer Science, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
 ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
 Also, \url{http://www.math.umn.edu/~spirn/5076/Lecture16.pdf}
}

