% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Compound.R
\name{CompoundBS}
\alias{CompoundBS}
\title{Compound option valuation with Black-Scholes (BS) model}
\usage{
CompoundBS(o = OptPx(Opt(Style = "Compound")), K1 = 10, T1 = 0.5,
  Type = c("cc", "cp", "pp", "pc"))
}
\arguments{
\item{o}{= \code{OptPx} object}

\item{K1}{The first Strike Price (of the option on the option)}

\item{T1}{The time of first expiry (of the option on the option)}

\item{Type}{Possible choices are
\code{cc} - call option on call option
\code{cp} - call on put
\code{pc} - put on call
\code{pp} - put on put}
}
\value{
A list of object 'OptCompound' containing the option parameters binomial tree parameters and compound option parameters
}
\description{
Compound option valuation with Black-Scholes (BS) model
}
\examples{
(o <- CompoundBS())$PxBS #price compound option with default parameters

o = OptPx(Opt(Style='Compound'), r=0.05, q=0.0, vol=0.25)
CompoundBS(o,K1=10,T1=0.5)

o = Opt(Style='Compound', S0=50, K=52, ttm=1)
CompoundBS(o=OptPx(o, r=.05, q=0, vol=.25),K1=6,T1=1.5)

o = Opt(Style='Compound', S0=90, K=100, ttm=1.5)
CompoundBS(o=OptPx(o, r=.05, q=0, vol=.25),K1=15,T1=1)

o = Opt(Style='Compound', S0=15, K=15, ttm=0.25)
CompoundBS(o=OptPx(o, r=.05, q=0, vol=.25),K1=3,T1=1.5)
}
\author{
Robert Abramov
}

