% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ForwardStart.R
\name{ForwardStartMC}
\alias{ForwardStartMC}
\title{Forward Start option valuation via Monte-Carlo (MC) simulation}
\usage{
ForwardStartMC(o = OptPx(Opt(Style = "ForwardStart")), tts = 0.1,
  NPaths = 5)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{tts}{Time to start of the option, in years.}

\item{NPaths}{The number of MC simulation paths.}
}
\value{
A list of class \code{ForwardStartMC} consisting of the input object
 \code{OptPx} and the appended new parameters and option price.
}
\description{
S3 object pricing model for a forward start European option using Monte Carlo simulation
}
\details{
A standard European option starts at a future time tts.
}
\examples{
(o = ForwardStartMC())$PxMC

o = OptPx(Opt(Style='ForwardStart'), q = 0.03, r = 0.1, vol = 0.15)
(o = ForwardStartMC(o, tts=0.25))$PxMC

ForwardStartMC(o = OptPx(Opt(Style='ForwardStart', Right='Put')))$PxMC
}
\author{
Tongyue Luo, Rice University, Spring 2015.
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall. ISBN 978-0-13-345631-8,
\url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}.
\cr \url{http://investexcel.net/forward-start-options/}
}

