% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Gap.R
\name{GapBS}
\alias{GapBS}
\title{Gap option valuation via Black-Scholes (BS) model}
\usage{
GapBS(o = OptPx(Opt(Style = "Gap", Right = "Put", S0 = 5e+05, K = 4e+05, ttm =
  1, ContrSize = 1, SName =
  "Insurance coverage example #26.1, p.601, OFOD, J.C.Hull, 9ed."), r = 0.05, q
  = 0, vol = 0.2), K2 = 350000)
}
\arguments{
\item{o}{An object of class \code{OptPx}}

\item{K2}{Strike price that determine if the option pays off.}
}
\value{
An original \code{OptPx} object with \code{PxBS} field as the price of the option
and user-supplied \code{K2} parameter
}
\description{
S3 object constructor for price of gap option using BS model
}
\examples{
#See J.C.Hull, OFOD'2014, 9-ed, Example 26.1, p.601
(o <- GapBS())$PxBS

GapBS(o=OptPx(Opt(Style='Gap',Right='Put',K=57)))

#See http://www.mathworks.com/help/fininst/gapbybls.html
o = Opt(Style='Gap',Right='Put',K=57,ttm=0.5,S0=52)
o = GapBS(OptPx(o,vol=0.2,r=0.09),K2=50)

o = Opt(Style='Gap',Right='Put',K=57,ttm=0.5,S0=50)
(o <- GapBS(OptPx(o,vol=0.2,r=0.09),K2=50))$PxBS
}
\author{
Tong Liu, Department of Statistics, Rice University, Spring 2015
}
\references{
Hull, John C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8. \url{http://www.mathworks.com/help/fininst/gapbybls.html}
}

