% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Quotient.R
\name{QuotientMC}
\alias{QuotientMC}
\title{Quotient option valuation via Monte Carlo (MC) model}
\usage{
QuotientMC(o = OptPx(Opt(Style = "Quotient")), S0_2 = 100, NPaths = 5)
}
\arguments{
\item{o}{The \code{OptQuotient} option object to price.}

\item{S0_2}{The spot price of the second underlying asset.}

\item{NPaths}{Number of monte-carlo simulations to run. Larger number of trials lower variability at the expense of computation time.}
}
\value{
An original \code{OptPx} object with Px.MC field as the price of the option and user-supplied S0_2, NPaths parameters attached.
}
\description{
Calculates the price of a Quotient option using Monte-Carlo simulations.
}
\details{
The Monte-Carlo simulations assume the underlying price undergoes Geometric Brownian Motion (GBM).
Payoffs are discounted at risk-free rate to price the option.
A thorough understanding of the object class construction is recommended.
Please see \code{OptPx}, \code{Opt} for more information.
}
\examples{
(o = QuotientMC())$PxMC #Default Quotient option price.

o = OptPx(Opt(S0=100, ttm=1, K=1.3), r=0.10, q=0, vol=0.1)
(o = QuotientMC(o, S0_2 = 180, NPaths=5))$PxMC

QuotientMC(OptPx(Opt()), S0_2 = 180, NPaths=5)

QuotientMC(OptPx(), S0_2 = 201, NPaths = 5)

QuotientMC(OptPx(Opt(S0=500, ttm=1, K=2)), S0_2 = 1000, NPaths=5)
}
\author{
Richard Huang, Department of Statistics, Rice University, Spring 2015
}
\references{
\url{http://www.investment-and-finance.net/derivatives/q/quotient-option.html}
}

