% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QFRM.R
\name{pbnorm}
\alias{pbnorm}
\title{Bivariate Standard Normal CDF}
\usage{
pbnorm(x = 0, y = 0, rho = 0)
}
\arguments{
\item{x}{The \eqn{x} value (want probability under this value of \eqn{x}); values in \eqn{(-25, 25)}}

\item{y}{The \eqn{y} value (want probability under this value of \eqn{y}); values in \eqn{(-25, 25)}}

\item{rho}{The correlation between variables \eqn{x} and \eqn{y}; values in \eqn{[-1, 1]}}
}
\value{
Density under the bivariate standard normal distribution
}
\description{
Bivariate Standard Normal CDF Calculator For Given Values of x, y, and rho
}
\details{
This runs a bivariate standard normal pdf then calculates the cdf from that based on the input parameters
}
\examples{
pbnorm(1, 1, .5)
#pbnorm(2, 2, 0)
#pbnorm(-1, -1, .35)
#pbnorm(0, 0, 0)

ttl = 'cdf of x, at y=0'
X = seq(-5,5,1)
graphics::plot(X, sapply(X, function(x) pbnorm(0,x,0)), type='l', main=ttl)
}
\author{
Robert Abramov, Department of Statistics, Rice University, 2015
}
\references{
Adapted from
"Bivariate normal distribution with R", Edouard Tallent's blog from Sep 21, 2012
\cr https://quantcorner.wordpress.com/2012/09/21/bivariate-normal-distribution-with-r
}

