% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NASH.R
\name{NASH}
\alias{NASH}
\title{Nash Equilibrium}
\usage{
NASH(P1, P2)
}
\arguments{
\item{P1}{Payoff matrix to Alice}

\item{P2}{Payoff matrix to Bob}
}
\value{
The cell positons of the Nash equilibrium/equilibria as a dataframe from the payoff matrices of the players.
}
\description{
This function finds out the Nash equilibria of the 2-D payoff matrix for the players. The input parameters are equal dimensional payoff matrices for the first and the second players.
}
\examples{
init()
Alice <- matrix(c(4, 3, 2, 4, 4, 2, 1, 0, 3, 5, 3, 5, 2, 3, 1, 3), ncol=4, byrow=TRUE)
Bob <- matrix(c(0, 2, 3, 8, 2, 1, 2, 2, 6, 5, 1, 0, 3, 2, 2, 3), ncol=4, byrow=TRUE)
NASH(Alice, Bob)

}
\references{
\url{https://arxiv.org/abs/1512.06808}\cr
\url{https://en.wikipedia.org/wiki/Nash_equilibrium}\cr
}
