% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combined_prob.R
\name{combined_prob}
\alias{combined_prob}
\title{Calculate combined probabilities of similarity or intersection metrics of tracks}
\usage{
combined_prob(data, metrics = NULL)
}
\arguments{
\item{data}{A \code{track} R object, which is a list consisting of two elements:
\itemize{
\item \strong{\code{Trajectories}}: A list of interpolated trajectories, where each trajectory is a series of midpoints between consecutive footprints.
\item \strong{\code{Footprints}}: A list of data frames containing footprint coordinates, metadata (e.g., image reference, ID), and a marker indicating whether the footprint is actual or inferred.
}}

\item{metrics}{A list of \code{track similarity} and/or \code{track intersection} R objects derived from different tests. All tests must be
based on the same number of simulations.}
}
\value{
A list containing:
\item{P_values (model names)}{A matrix of \emph{p}-values for the combined metrics across all trajectories. Each entry represents
the probability of observing the combined metrics between the corresponding pair of trajectories.}
\item{P_values_combined (model names)}{A numeric value representing the overall probability of observing the combined metrics,
across all pairs of trajectories.}
}
\description{
\code{combined_prob()} calculates the combined probabilities of similarity and intersection metrics
derived from different models. The function uses simulation data to extract \emph{p}-values, providing insight into
the significance of combined metrics across various similarity assessments.
}
\details{
The \code{combined_prob()} function combines \emph{p}-values derived from multiple similarity metric tests and intersection tests.
It calculates the combined \emph{p}-values by assessing the probability of observing the combined metrics across simulated datasets.
This function is particularly useful for comparing multiple models and evaluating their collective performance in terms of \emph{p}-values.
}
\section{Logo}{

\if{html}{\figure{Logo.png}{options: width=30\%}}
}

\examples{
# Example 1: "Directed" model and similarity metrics.
s1 <- simulate_track(PaluxyRiver, nsim = 3, model = "Directed")
DTW1 <- simil_DTW_metric(PaluxyRiver, test = TRUE, sim = s1, superposition = "None")
Frechet1 <- simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s1, superposition = "None")
int1 <- track_intersection(PaluxyRiver, test = TRUE, H1 = "Lower", sim = s1,
  origin.permutation = "None")
combined_prob(PaluxyRiver, metrics = list(DTW1, Frechet1, int1))

# Example 2: "Constrained" model and similarity metrics.
s2 <- simulate_track(PaluxyRiver, nsim = 3, model = "Constrained")
DTW2 <- simil_DTW_metric(PaluxyRiver, test = TRUE, sim = s2,
  superposition = "None")
Frechet2 <- simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s2,
  superposition = "None")
int2 <- track_intersection(PaluxyRiver, test = TRUE, H1 = "Lower", sim = s2,
  origin.permutation = "Min.Box")
combined_prob(PaluxyRiver, metrics = list(DTW2, Frechet2, int2))

# Example 3: "Unconstrained" model and similarity metrics.
s3 <- simulate_track(PaluxyRiver, nsim = 3, model = "Unconstrained")
DTW3 <- simil_DTW_metric(PaluxyRiver, test = TRUE, sim = s3,
  superposition = "None")
Frechet3 <- simil_Frechet_metric(PaluxyRiver, test = TRUE, sim = s3,
  superposition = "None")
int3 <- track_intersection(PaluxyRiver, test = TRUE, H1 = "Lower", sim = s3,
  origin.permutation = "Conv.Hull")
combined_prob(PaluxyRiver, metrics = list(DTW3, Frechet3, int3))

}
\seealso{
\code{\link{tps_to_track}}, \code{\link{simulate_track}}, \code{\link{track_intersection}}, \code{\link{simil_DTW_metric}}, \code{\link{simil_Frechet_metric}}
}
\author{
Humberto G. Ferrón

humberto.ferron@uv.es

Macroevolution and Functional Morphology Research Group (www.macrofun.es)

Cavanilles Institute of Biodiversity and Evolutionary Biology

Calle Catedrático José Beltrán Martínez, nº 2

46980 Paterna - Valencia - Spain

Phone: +34 (9635) 44477
}
