% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CleanRaw.R
\name{CleanRaw}
\alias{CleanRaw}
\title{Generate Clean Raw Data}
\usage{
CleanRaw(meta, raw, plate_time, cycle_total)
}
\arguments{
\item{meta}{A data frame containing the metadata. Output from CleanMeta function.}

\item{raw}{Raw fluorescence readings from MARS software.}

\item{plate_time}{Output of \code{ConvertTime()}.}

\item{cycle_total}{The total number of cycles (rows) to include in the output.}
}
\value{
A data frame containing the cleaned raw fluorescence data.
}
\description{
This function takes metadata, raw data, and total cycle information to generate clean raw fluorescence data.
}
\examples{
# Define the path to the plate data file
plate_path <- system.file("extdata/20240716_p3", 
                          file = '20240716_p3_plate.xlsx', 
                          package = "QuICSeedR")
  
# Read the plate data
plate <- readxl::read_xlsx(plate_path)

# Define the path to the raw data file
raw_path <- system.file("extdata/20240716_p3", 
                        file = '20240716_p3_raw.xlsx', 
                        package = "QuICSeedR")
# Read the raw data
raw <- readxl::read_xlsx(raw_path)

# Get replicate data
replicate <- GetReplicate(plate)

# Ensure time displayed as decimal hours
plate_time = ConvertTime(raw)

#Get metadata and display the few rows 
meta = CleanMeta(raw, plate, replicate)

#Clean data 
cleaned_data <- CleanRaw(meta, raw, plate_time)

cleaned_data[1:5, 1:5]

}
