% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPerformance.R
\name{calcPerformance}
\alias{calcPerformance}
\title{Calculate measure performance by accountable entity}
\usage{
calcPerformance(
  df = NULL,
  model = NULL,
  entity = "entity",
  y = "y",
  data.type = "binary",
  ctrPerf = controlPerf()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{data.type}{acceptable values are \code{binary} for 0/1 data (default: \code{binary})}

\item{ctrPerf}{parameters to control performance measure calculation}
}
\value{
A list including:
*\code{df}: a cleaned dataframe used to calculate measure performance
*\code{model}: the model used to calculate measure performance
*\code{fit}: the fitted model results
*\code{marg.p}: overall, unadjusted average performance across all entities
*\code{perf.results}: performance results by entity
}
\description{
This function calculates measure performance by accountable entity.
}
\examples{
# simulate data
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# calculate measure performance
out <- calcPerformance(df = df, entity = 'entity', y = 'y')

# plot performance
plotPerformance(out$perf.results)

}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
