% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcSSR.R
\name{calcSSR}
\alias{calcSSR}
\title{Calculate reliability using split-sample method}
\usage{
calcSSR(
  df = NULL,
  model = NULL,
  entity = "entity",
  y = "y",
  data.type = "binary",
  ctrPerf = controlPerf(),
  ctrRel = controlRel()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{data.type}{acceptable values are \code{binary} for 0/1 data and \code{continuous} for continuous data (default: \code{binary})}

\item{ctrPerf}{parameters to control performance measure calculation}

\item{ctrRel}{parameters to control reliability estimation}
}
\value{
A list containing:
\itemize{
\item \code{entity}: list of entities
\item \code{n}: entity sample sizes
\item \code{icc}: Spearman-Brown-adjusted intraclass correlation coefficients for each resample
\item \code{icc.lb}: lower bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for each resample
\item \code{icc.ub}: upper bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for each resample
\item \code{est.SSR}: reliability estimate based on a single split
\item \code{est.PSSR}: mean reliability estimate across resamples
}

If a risk-adjustment model is included then, the outputted list will contain:
\itemize{
\item \code{entity}: list of entities
\item \code{n}: entity sample sizes
\item \code{icc.oe}: Spearman-Brown-adjusted intraclass correlation coefficients for OE ratios for each resample
\item \code{icc.oe.lb}: lower bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for OE ratios for each resample
\item \code{icc.oe.ub}: upper bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for OE ratios for each resample
\item \code{icc.pe}: Spearman-Brown-adjusted intraclass correlation coefficients for PE ratios for each resample
\item \code{icc.pe.lb}: lower bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for PE ratios for each resample
\item \code{icc.pe.ub}: upper bound on confidence interval for Spearman-Brown-adjusted intraclass correlation coefficients for PE ratios for each resample
\item \code{est.SSR.oe}: reliability estimate for OE ratio based on a single split
\item \code{est.PSSR.oe}: mean reliability estimate for OE ratio across resamples
\item \code{est.SSR.pe}: reliability estimate for PE ratio based on a single split
\item \code{est.PSSR.pe}: mean reliability estimate for PE ratio across resamples
}
}
\description{
This function estimates reliability using the split-sample method.
}
\examples{
# Simulate data
df <- simulateData(n.entity = 50, n.obs = 100, mu = .2, r = .7)

# Calculate reliability
out <- calcSSR(df = df, entity = 'entity', y = 'y', ctrRel = controlRel(n.resamples = 10))
out$est.PSSR

# Distribution of estimates obtained from the permutation sampling.
hist(out$icc)
summary(out$icc)


}
\references{
Nieser KJ, Harris AH. Comparing methods for assessing the reliability of health care quality measures. Statistics in Medicine. 2024 Oct 15;43(23):4575-94.
}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
