% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\title{Calculate model performance}
\usage{
model_performance(
  df,
  model,
  entity = "entity",
  y = "y",
  data.type = "binary",
  predictor.clean = NULL,
  ctrPerf = controlPerf()
)
}
\arguments{
\item{df}{observation-level data; if null, will use the dataframe from the model object}

\item{model}{model; if null, will use an unadjusted model}

\item{entity}{data column containing the accountable entity identifier}

\item{y}{data column containing the outcome variable}

\item{data.type}{acceptable values are \code{binary} for 0/1 data and \code{continuous} for continuous data (default: \code{binary})}

\item{predictor.clean}{optional list of formatted names of predictors in the model}

\item{ctrPerf}{parameters to control performance measure calculation}
}
\value{
A list containing:
*\code{data.type}: type of data: binary or continuous
*\code{model}: risk-adjustment model
*\code{fit}: fitted model results
*\code{marg.p}: overall, unadjusted outcome rate (for binary outcome data only)
*\code{c.statistic}: c-statistic, a measure of discrimination
*\code{model.results}: a dataframe with one row for each predictor in the model
}
\description{
This function calculates risk model performance.
}
\examples{
# Simulate data
df <- simulateData(n.entity = 100, n.obs = 80, mu = 0.2, r = 0.6, beta1 = log(1.6))

# Calculate risk-adjustment model performance
model.perf <- model_performance(df = df, model = 'y ~ x1 + (1|entity)')

# Plot estimated effects of predictors
plotEstimates(model.perf)


}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
