% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{simulateData}
\alias{simulateData}
\title{Simulate data}
\usage{
simulateData(
  n.entity,
  n.obs,
  mu,
  sd = 1,
  r,
  beta1 = 0,
  data.type = "binary",
  dist = "normal"
)
}
\arguments{
\item{n.entity}{total number of entities to simulate}

\item{n.obs}{average number of observations per entity; entity sample sizes are simulated from a Poisson distribution with mean given by n.obs OR a vector of length n.entity with entity sample sizes}

\item{mu}{average probability of the outcome for binary data OR average outcome value for Normal data}

\item{sd}{within-entity standard deviation for Normal data (default is \code{1}).}

\item{r}{median reliability}

\item{beta1}{regression coefficient for covariate added to the linear predictor; default is \code{0}. Note that for binary data, \code{beta1} is on the log odds scale (e.g., \code{beta1} = 0.4 corresponds to an odds ratio of about 1.5).}

\item{data.type}{type of data to simulate. Valid options include: \code{binary} (default) and \code{normal}.}

\item{dist}{specifies the distribution family to use to simulate provider performance. Valid options include: \code{normal} (default) and \code{beta}.}
}
\value{
A dataframe of simulated data.
}
\description{
This function simulates some data.
}
\examples{
# number of accountable entities
n.entity = 100

# average number of patients or cases per accountable entity
n.obs = 50

# marginal probability of the outcome
mu = 0.1

# approximate reliability for entity with a median number of patients
r = 0.6

# parameter for risk-adjustment model (i.e., coefficient for x1)
beta1 = log(1.5)

df <- simulateData(n.entity = n.entity, n.obs = n.obs, mu = mu, r = r, beta1 = beta1)
head(df)

}
\author{
Kenneth Nieser (nieser@stanford.edu)
}
