% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Quandlsearch.R
\name{Quandl.search}
\alias{Quandl.search}
\title{Search the Quandl database}
\usage{
Quandl.search(query, silent = FALSE, per_page = 10, ...)
}
\arguments{
\item{query}{Search terms}

\item{silent}{Prints the results when FALSE.}

\item{per_page}{Number of results returned per page.}

\item{...}{Additional named values that are interpretted as Quandl API parameters.}
}
\value{
Search results returned as a data.frame.
}
\description{
Search the Quandl database
}
\details{
Set your \code{api_key} with \code{Quandl.api_key} function. For instructions on finding your api key go to \url{https://www.quandl.com/account/profile}

For instructions on finding your authentication token go to https://www.quandl.com/account/profile
}
\examples{
\dontrun{
search.results <- Quandl.search("oil")
}
}
\seealso{
\code{\link{Quandl.api_key}}
}
