% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrglasso.R
\name{plot.qrglasso.predict}
\alias{plot.qrglasso.predict}
\title{Display Predicted Coefficient Functions from \code{qrglasso}}
\usage{
\method{plot}{qrglasso.predict}(x, ...)
}
\arguments{
\item{x}{An object of class \code{qrglasso.predict} for the \code{plot} method.}

\item{...}{Additional parameters not used directly.}
}
\value{
\code{NULL}
}
\description{
Visualize the predicted coefficient functions selected by BIC.
}
\examples{
set.seed(123)
n <- 100
p <- 5
L <- 5
Y <- matrix(rnorm(n), n, 1)
W <- matrix(rnorm(n * p * (L - 1)), n, p * (L - 1))

# Call qrglasso with default parameters
result <- qrglasso(Y = Y, W = W, p = p)

# Predict the top-k coefficient functions
estimate <- predict(result, top_k = 2)

# Display the predicted coefficient functions
plot(estimate)

}
\seealso{
\code{\link{qrglasso}}
}
