% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrglasso.R
\name{predict}
\alias{predict}
\title{Predict Top-k Coefficient Functions}
\usage{
predict(
  qrglasso_object,
  metric_type = "BIC",
  top_k = 5,
  degree = 2,
  boundaries = c(0, 1),
  is_approx = FALSE
)
}
\arguments{
\item{qrglasso_object}{A \code{qrglasso} class object.}

\item{metric_type}{Character. Metric type for gamma selection, e.g., \code{BIC}, \code{BIC-log}. Default is \code{BIC}.}

\item{top_k}{Integer. The number of top estimated functions to predict. Default is 5.}

\item{degree}{Integer. Degree of the piecewise polynomial. Default is 2.}

\item{boundaries}{Array. Two boundary points for the piecewise polynomial. Default is c(0, 1).}

\item{is_approx}{Logical. If TRUE, the size of covariate indexes will be 1e6; otherwise, 1e4. Default is FALSE.}
}
\value{
A list containing:
\item{\code{coef_functions}}{Matrix. The estimated top-k coefficient functions with dimension (\eqn{m \times k}), where \eqn{m} is the size of \code{z}.}
\item{\code{z}}{Array. Index predictors used in the generation.}
}
\description{
Predict the top-k coefficient functions based on a \code{qrglasso} class object.
}
\examples{
set.seed(123)
n <- 100
p <- 5
L <- 5
Y <- matrix(rnorm(n), n, 1)
W <- matrix(rnorm(n * p * (L - 1)), n, p * (L - 1))

# Call qrglasso with default parameters
result <- qrglasso(Y = Y, W = W, p = p)
estimate <- predict(result) 
print(dim(estimate$coef_functions))

}
\seealso{
\code{\link{qrglasso}}
}
